<?php
require_once __DIR__ . '/db.php';
session_start();
function login($email, $password){
  global $pdo;
  $st = $pdo->prepare("SELECT id,name,email,password_hash,role FROM users WHERE email=? LIMIT 1");
  $st->execute([$email]);
  $u = $st->fetch();
  if($u && password_verify($password, $u['password_hash'])){
    $_SESSION['user'] = ['id'=>$u['id'],'name'=>$u['name'],'email'=>$u['email'],'role'=>$u['role']];
    return true;
  }
  return false;
}
function current_user(){ return $_SESSION['user'] ?? null; }
function is_admin(){ $u=current_user(); return $u && $u['role']==='admin'; }
function is_caretaker(){ $u=current_user(); return $u && $u['role']==='caretaker'; }
function require_login(){ if(!current_user()){ header('Location: login.php'); exit; } }
function logout(){ session_destroy(); header('Location: login.php'); exit; }
?>