<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';

$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT i.*, t.name AS tenant_name, t.email, t.phone, p.name AS property_name FROM invoices i 
LEFT JOIN tenants t ON t.id=i.tenant_id 
LEFT JOIN properties p ON p.id=t.property_id
WHERE i.id=? LIMIT 1");
$st->execute([$id]);
$inv = $st->fetch();
if(!$inv){ echo 'Invoice not found'; exit; }

$settings = $pdo->query("SELECT `key`,`value` FROM settings")->fetchAll();
$map=[]; foreach($settings as $s){ $map[$s['key']]=$s['value']; }
$logo = $map['logo_url'] ?? '';
$biz = $map['business_name'] ?? 'Business';
$addr = $map['business_address'] ?? '';
$phone = $map['business_phone'] ?? '';
$prefix = $map['invoice_prefix'] ?? 'INV';
$code = $prefix . '-' . $inv['id'];
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Invoice <?= e($code) ?></title>
<style>
  body{font-family:Arial,Helvetica,sans-serif;margin:24px}
  .top{display:flex;justify-content:space-between;align-items:center}
  .muted{color:#6b7280}
  table{width:100%;border-collapse:collapse;margin-top:16px}
  th,td{border:1px solid #e5e7eb;padding:8px;text-align:left}
  .total{font-weight:700}
  .print{position:fixed;right:24px;top:24px;padding:8px 12px;background:#0ea5e9;color:#fff;border:none;border-radius:8px;cursor:pointer}
</style></head><body>
<button class="print" onclick="window.print()">Print</button>
<div class="top">
  <div>
    <h2><?= e($biz) ?></h2>
    <div class="muted"><?= e($addr) ?></div>
    <div class="muted">Phone: <?= e($phone) ?></div>
  </div>
  <div><?php if($logo): ?><img src="<?= e($logo) ?>" alt="logo" style="max-height:70px"><?php endif; ?></div>
</div>
<hr>
<h3>Invoice <?= e($code) ?></h3>
<div>Tenant: <strong><?= e($inv['tenant_name']) ?></strong> — <?= e($inv['email']) ?> / <?= e($inv['phone']) ?></div>
<div>Property: <?= e($inv['property_name']) ?></div>
<div>Issue: <?= e($inv['issue_date']) ?> • Due: <?= e($inv['due_date']) ?> • Status: <?= e($inv['status']) ?></div>
<table>
  <tr><th>Description</th><th>Amount (KES)</th></tr>
  <tr><td>Monthly Rent</td><td><?= number_format($inv['amount_due'] - ($inv['water_fee']+$inv['garbage_fee']+$inv['extra_fee']),2) ?></td></tr>
  <?php if($inv['water_fee']>0): ?><tr><td>Water</td><td><?= number_format($inv['water_fee'],2) ?></td></tr><?php endif; ?>
  <?php if($inv['garbage_fee']>0): ?><tr><td>Garbage</td><td><?= number_format($inv['garbage_fee'],2) ?></td></tr><?php endif; ?>
  <?php if($inv['extra_fee']>0): ?><tr><td>Other</td><td><?= number_format($inv['extra_fee'],2) ?></td></tr><?php endif; ?>
  <tr class="total"><td>Total Due</td><td><?= number_format($inv['amount_due'],2) ?></td></tr>
  <tr><td>Paid</td><td><?= number_format($inv['amount_paid'],2) ?></td></tr>
  <tr class="total"><td>Balance</td><td><?= number_format($inv['amount_due']-$inv['amount_paid'],2) ?></td></tr>
</table>
<p class="muted">Notes: <?= e($inv['notes']) ?></p>
</body></html>
