<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();

$props = $pdo->query("SELECT id,name FROM properties ORDER BY name")->fetchAll();
$search = trim($_GET['q'] ?? ''); $where='1=1'; $params=[];
if($search!==''){ $where.=" AND (u.name LIKE ? OR p.name LIKE ?)"; $params=["%$search%","%$search%"]; }
if(is_caretaker()){ $uid=current_user()['id']; $where .= " AND u.property_id IN (SELECT property_id FROM caretaker_properties WHERE user_id=?)"; $params[]=$uid; }
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create']) && is_admin()){
    $pdo->prepare("INSERT INTO units (property_id,name) VALUES (?,?)")->execute([(int)$_POST['property_id'], $_POST['name']]);
  } elseif(isset($_POST['delete']) && is_admin()){
    $pdo->prepare("DELETE FROM units WHERE id=?")->execute([(int)$_POST['id']]);
  } elseif(isset($_POST['update']) && is_admin()){
    $pdo->prepare("UPDATE units SET property_id=?, name=? WHERE id=?")->execute([(int)$_POST['property_id'], $_POST['name'], (int)$_POST['id']]);
  }
}
$rows_st=$pdo->prepare("SELECT u.*, p.name property_name FROM units u LEFT JOIN properties p ON p.id=u.property_id WHERE $where ORDER BY u.id DESC");
$rows_st->execute($params); $rows=$rows_st->fetchAll();
?>
<h2>Units</h2>
<form class="searchrow" method="get">
  <input name="q" value="<?= e($search) ?>" placeholder="Search units / property">
  <button class="btn"><?= filter_icon() ?> Filter</button>
</form>
<?php if(is_admin()): ?>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Unit Name</label><input name="name" required></div>
  <div class="card"><label>Property</label><select name="property_id"><?php foreach($props as $p): ?><option value="<?= e($p['id']) ?>"><?= e($p['name']) ?></option><?php endforeach; ?></select></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="create">Add Unit</button></div>
</form>
<?php endif; ?>
<table>
  <tr><th>ID</th><th>Unit</th><th>Property</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td>
    <td><?= e($r['name']) ?></td>
    <td><?= e($r['property_name']) ?></td>
    <td>
      <?php if(is_admin()): ?>
      <form method="post" style="display:inline-block">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <input type="hidden" name="name" value="<?= e($r['name']) ?>">
        <input type="hidden" name="property_id" value="<?= e($r['property_id']) ?>">
        <button class="btn" onclick="return editRow(this)">Edit</button>
      </form>
      <form method="post" style="display:inline-block" onsubmit="return confirm('Delete unit?')">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <button class="btn" name="delete">Delete</button>
      </form>
      <?php endif; ?>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<script>
function editRow(btn){
  const f=btn.closest('form'); const id=f.querySelector('[name=id]').value;
  const name=f.querySelector('[name=name]').value; const property_id=f.querySelector('[name=property_id]').value;
  const row=btn.closest('tr');
  row.outerHTML=`<tr>
    <td>${id}</td>
    <td><form method="post"><input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="${id}"><input name="name" value="${name}"></td>
    <td><select name="property_id"><?php foreach($props as $p): ?><option value="<?= e($p['id']) ?>" ${property_id==="<?= e($p['id']) ?>"?'selected':''><?= e($p['name']) ?></option><?php endforeach; ?></select></td>
    <td><button class="btn primary" name="update">Save</button></form></td>
  </tr>`; return false;
}
</script>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
